/** @file   lightfencemanager.cpp
 * @brief   Implementation of LightFenceManager - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#include "lightfencemanager.h"

namespace eng2d {

///
/// Static members, constants and datatypes
/// =======================================




///
/// Constructors, destructor and operators
/// ======================================
/** Constructor
 */
LightFenceManager::LightFenceManager()
{
}



/** Destructor
 */
LightFenceManager::~LightFenceManager()
{
  this->clear();
}




///
/// Public methods
/// ==============

/** Adds new lightfence
 */
void LightFenceManager::addLightFence( LightFence* pLF )
{
  m_fences.push_back( pLF );
}



/** Destroyes the light fences
 */
void LightFenceManager::clear()
{
  for ( int i=0; i < m_fences.size(); i++ ) {
    if ( m_fences.at(i) != 0 ) {
      delete m_fences.at(i);
    }
  }
  m_fences.clear();
}



/** Updates the light fences
 */
void LightFenceManager::update()
{
  for ( int i=0; i < m_fences.size(); i++ ) {
    m_fences.at(i)->update();
  }
}



/** Draws the light fences
 */
void LightFenceManager::redraw( BITMAP* pB, const Vec2D& offset )
{
  for ( int i=0; i < m_fences.size(); i++ ) {
    m_fences.at(i)->redraw( pB, offset );
  }
}


///
/// Getter methods
/// ==============

/** Returns the number of lightfences there are.
 */
int LightFenceManager::fenceCount() const
{
  return m_fences.size();
}



/** Returns the index'th fence.
 */
LightFence* LightFenceManager::getFence( int fenceIndex ) const
{
  if ( fenceIndex < 0 || fenceIndex >= m_fences.size() ) {
    return 0;
  }
  return m_fences.at( fenceIndex );
}


/** Returns the fence that touches the given point
 */
LightFence* LightFenceManager::lightfenceTouch( const Vec2D& rP, float dist ) const
{
  for ( int i=0; i < m_fences.size(); i++ ) {
    if ( m_fences.at(i)->touches( rP, dist ) == true ) {
      return m_fences.at(i);
    }
  }
  return 0;
}


///
/// Private or Protected methods
/// ============================

} // end of namespace
